

<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="users-header">
        <h1 class="h1">Users</h1>
        <p class="text-secondary">Browse and search for community members</p>
    </div>

    <div class="user-search">
        <form action="<?php echo e(route('users.index')); ?>" method="GET" class="search-form">
            <input 
                type="text" 
                name="search" 
                class="search-input" 
                placeholder="Search by name or Steam" 
                value="<?php echo e($search ?? ''); ?>"
            >
            <button type="submit" class="search-button">
                <i class="fas fa-search"></i> Search
            </button>
        </form>
    </div>

    <div class="user-filters">
        <h3 class="filter-title">Filter by Role</h3>
        <form action="<?php echo e(route('users.index')); ?>" method="GET" id="role-filter-form">
            <?php if($search): ?>
            <input type="hidden" name="search" value="<?php echo e($search); ?>">
            <?php endif; ?>
            
            <div class="role-options">
                <label class="role-option">
                    <input 
                        type="radio" 
                        name="role" 
                        value="" 
                        <?php echo e(!$role ? 'checked' : ''); ?> 
                        onchange="document.getElementById('role-filter-form').submit()"
                    >
                    <span class="role-label">All Roles</span>
                </label>
                
                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roleOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <label class="role-option">
                    <input 
                        type="radio" 
                        name="role" 
                        value="<?php echo e($roleOption); ?>" 
                        <?php echo e($role == $roleOption ? 'checked' : ''); ?>

                        onchange="document.getElementById('role-filter-form').submit()"
                    >
                    <span class="role-label"><?php echo e(ucfirst($roleOption)); ?></span>
                </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </form>
    </div>

    <div class="users-list">
        <?php if($users->count() > 0): ?>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="user-card <?php echo e($user->banner ? 'has-banner' : ''); ?>">
                <?php if($user->banner): ?>
                    <img src="<?php echo e(Storage::url('user_banners/' . $user->banner)); ?>" alt="" class="user-banner">
                <?php endif; ?>
                
                <div class="user-avatar">
                    <img src="<?php echo e($user->avatar); ?>" alt="<?php echo e($user->name); ?>">
                </div>
                
                <div class="user-info">
                    <div class="user-header">
                        <h3 class="user-name"><?php echo e($user->name); ?></h3>
                        <?php if($user->getRoleNames()->count() > 0): ?>
                        <div class="user-role-tag">
                            <span class="role-badge"><?php echo e(ucfirst($user->getRoleNames()->first())); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="user-meta">
                        <?php if($user->steamid): ?>
                        <span class="steam-id">
                            <i class="fab fa-steam"></i> 
                            <?php echo e($user->steamid); ?>

                        </span>
                        <?php endif; ?>
                        <span class="join-date">
                            <i class="fas fa-calendar"></i> Joined <?php echo e($user->created_at->format('M d, Y')); ?>

                        </span>
                    </div>
                </div>
                
                <div class="user-actions">
                    <a href="<?php echo e(route('users.show', $user->slug)); ?>" class="btn-view">
                        <i class="fas fa-eye"></i> View
                    </a>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <div class="user-pagination">
                <?php echo e($users->links()); ?>

            </div>
        <?php else: ?>
            <div class="users-empty-state">
                <div class="empty-icon">
                    <i class="fas fa-users-slash"></i>
                </div>
                <h3 class="empty-text">No users found</h3>
                <p class="text-secondary mb-md">
                    <?php if($search || $role): ?>
                        Try adjusting your search or filter criteria
                    <?php else: ?>
                        There are no users registered yet
                    <?php endif; ?>
                </p>
                
                <?php if($search || $role): ?>
                <a href="<?php echo e(route('users.index')); ?>" class="btn-add-user">
                    <i class="fas fa-sync"></i> Reset Filters
                </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/users/index.blade.php ENDPATH**/ ?>